#version 120

uniform sampler2D depthtex0;
uniform sampler2D gcolor;
uniform float near;
uniform float far;
uniform int isEyeInWater;
varying vec4 texcoord;

float getDepths(vec2 coord, float clipping) {
    return clamp(2.0 * near * far / (far + near - (2.0 * texture2D(depthtex0, coord).x - 1.0) * (far - near)) / clipping, 0.5, 1);
}

void main()
{
  vec3 finalColor = texture2D(gcolor, texcoord.st).rgb;
  if(isEyeInWater == 1)
  {
    finalColor = finalColor * vec3(0.2, 0.6, 1.0) * (1-getDepths(texcoord.st, 60))*2;
  }
  if(isEyeInWater == 2)
  {
    finalColor = mix(finalColor, vec3(0.7, 0.2, 0.0), getDepths(texcoord.st, 3))/vec3(5);
  }
  gl_FragData[0] = vec4(finalColor, 1.0);
}
